@extends('layouts.app')
@section('header')
<link href="/sales/public/dist/css/bootstrap.min.css" rel="stylesheet" media="screen">
<link href="/sales/public/dist/css/bootstrap-datetimepicker.min.css" rel="stylesheet" media="screen">
@endsection
@section('content')
<div class="container">
   <div class="row">
      <div class="col-md-10 col-md-offset-1">
         <div class="panel panel-default">
            <div class="panel-heading"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp;&nbsp;新增一個客戶專案&nbsp;</div>
            <div class="panel-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <strong>新增失敗</strong> 输入不符合要求<br><br>
                  {!! implode('<br>', $errors->all()) !!}
               </div>
               @endif
               <form action="{{ url('/project') }}" method="POST" enctype="multipart/form-data">
                  {!! csrf_field() !!}
                  <div class="form-group">
                     <label >留言日期</label>
                     <div class="input-group date form_datetime col-md-5" Defaul='true' data-date-format="dd MM yyyy - HH:ii p" data-link-field="dtp_input1">
                        <input class="form-control" size="16" type="text" value="" readonly>
                        <span class="input-group-addon"><span class="glyphicon glyphicon-remove"></span></span>
                        <span class="input-group-addon"><span class="glyphicon glyphicon-th"></span></span>
                     </div>
                     <input name = "comment_time" type="hidden" id="dtp_input1" value="" /><br/>
                  </div>

                  <fieldset class="form-group">
                     <label for="exampleSelect1">客戶負責人</label>
                     <select class="form-control"  name="user">


                        <option value='1' >N/A</option>
                        <option  value='2' >Reene</option>
                        <option  value='4'>Chris</option>
                        <option  value='5'>Chubby</option>


                     





                     </select>
                  </fieldset>



                   <fieldset class="form-group">
                     <label for="exampleSelect1">客戶類型</label>
                     <select class="form-control" id="exampleSelect1" name="type">
                        <option>DV</option>
                        <option>KEYPO</option>
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >公司名稱</label>
                     <input type="text" name="company" value="" class="form-control"  placeholder="請輸入公司名稱">
                  </fieldset>
                 
                  

                   <fieldset class="form-group">
                     <label for="exampleSelect1">專案等級</label>
                     <select class="form-control" id="exampleSelect1" name="level">
                        <option>A</option>
                        <option>B</option>
                        <option>C</option>
                        <option>D</option>
                        <option>E</option>
                        <option>F</option>
                        <option>G</option>
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >聯絡人</label>
                     <input type="text" name="contacter" value="{{ old('contacter') }}" class="form-control"  placeholder="請輸入聯絡人姓名">
                  </fieldset>


                  <fieldset class="form-group">
                     <label  >職稱</label>
                     <input type="text" name="job" value="{{ old('job') }}" class="form-control"  placeholder="請輸入聯絡人職稱">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >手機號碼</label>
                     <input type="text" name="phone" value="{{ old('phone') }}" class="form-control"  placeholder="請輸入聯絡人手機號碼">
                  </fieldset>



                  <fieldset class="form-group">
                     <label  >公司電話</label>
                     <input type="text" name="telephone"   value="{{ old('telephone') }}" class="form-control"  placeholder="請輸入公司電話">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >Email</label>
                     <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" placeholder="請輸入聯絡人 Email">

                  </fieldset>

                    <fieldset class="form-group">
                     <label  >地址</label>
                     <input type="text" name="address" value="{{ old('address') }}" class="form-control"  placeholder="請輸入公司地址">
                  </fieldset>
                  

                   <fieldset class="form-group">
                     <label  >拜訪</label>
                     <select class="form-control"   name="visited">
                        <option>V</option>
                        <option>-</option>
                        <option>X</option>
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >合作方法</label>
                     <input type="text" name="coperate_method" value="{{ old('coperate_method') }}" class="form-control"  placeholder="請輸入合作方法">
                  </fieldset>


                  <fieldset class="form-group">
                     <label  >合作內容</label>
                     <input type="text" name="coperate_content" value="{{ old('coperate_content') }}" class="form-control"  placeholder="請輸入合作內容">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >第一次聯繫資訊</label>
                     <input type="text" name="first_contact" value="{{ old('first_contact') }}" class="form-control"  placeholder="請輸入第一次聯繫資訊">
                  </fieldset>


                  <fieldset class="form-group">
                      <label  >第二次聯繫資訊</label>
                     <input type="text" name="second_contact" value="{{ old('second_contact') }}" class="form-control"  placeholder="請輸入第一次聯繫資訊">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >第三次聯繫資訊</label>
                     <input type="text" name="third_contact" value="{{ old('third_contact') }}" class="form-control"  placeholder="請輸入第一次聯繫資訊">
                  </fieldset>



                   <fieldset class="form-group">
                     <label  >成交狀態</label>
                     <select class="form-control"   name="deal">
                        <option>回傳訂單</option>
                        <option>已付款</option>
                        <option>結案(指專案完成了)</option>
                        <option>長期追蹤</option>
                        <option>不聯絡</option>
                        <option>聯繫中</option>
                     </select>
                  </fieldset>




                  <fieldset class="form-group">
                     <label  >預算(萬)</label>
                     <input type="number" name ="budget" class="form-control"  min="0" step="1"  />
                  </fieldset>


                  <fieldset class="form-group">
                     <label  >備註</label>
                     <textarea name="remark" rows="10" class="form-control"  placeholder="請輸入專案備註"></textarea>
                  </fieldset>

                  <button class="btn btn-lg btn-info">新增專案</button>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
@section('footer')
<!-- Latest compiled and minified JavaScript -->
<script type="text/javascript" src="/sales/public/dist/js/bootstrap-datetimepicker.js" charset="UTF-8"></script>
<script type="text/javascript" src="/sales/public/dist/js/locales/bootstrap-datetimepicker.fr.js" charset="UTF-8"></script>
<script type="text/javascript">
   $('.form_datetime').datetimepicker({
       //language:  'fr',
       weekStart: 1,
       todayBtn:  1,
   autoclose: 1,
   todayHighlight: 1,
   startView: 2,
   forceParse: 0,
       showMeridian: 1
   });
   $('.form_date').datetimepicker({
       language:  'fr',
       weekStart: 1,
       todayBtn:  1,
   autoclose: 1,
   todayHighlight: 1,
   startView: 2,
   minView: 2,
   forceParse: 0
   });
   $('.form_time').datetimepicker({
       language:  'fr',
       weekStart: 1,
       todayBtn:  1,
   autoclose: 1,
   todayHighlight: 1,
   startView: 1,
   minView: 0,
   maxView: 1,
   forceParse: 0
   });
</script>
@endsection