@extends('layouts.app')
@section('header')
<link href="dist/css/bootstrap.min.css" rel="stylesheet" media="screen">
<link href="dist/css/bootstrap-datetimepicker.min.css" rel="stylesheet" media="screen">
@endsection
@section('content')
<div class="container">
   <div class="row">
      <div class="col-md-10 col-md-offset-1">
         <div class="panel panel-default">
            <div class="panel-heading"><i class="fa fa-plus" aria-hidden="true"></i>&nbsp;&nbsp;修改專案&nbsp;{{$project->company}}  &nbsp;</div>
            <div class="panel-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <strong>新增失敗</strong> 输入不符合要求<br><br>
                  {!! implode('<br>', $errors->all()) !!}
               </div>
               @endif
               <form action="{{ url('project/'.$project->id) }}" method="POST" enctype="multipart/form-data">
                  {!! csrf_field() !!}
                  {{method_field("PATCH")}}
                  <div class="form-group">
                     <label >留言日期</label>
                     <div class="input-group date form_datetime col-md-5"  defaul='true' data-date-format="dd MM yyyy - HH:ii p" data-link-field="dtp_input1">
                        <input class="form-control" size="16" type="text" value="{{$project->comment_time}}" readonly>
                        <span class="input-group-addon"><span class="glyphicon glyphicon-remove"></span></span>
                        <span class="input-group-addon"><span class="glyphicon glyphicon-th"></span></span>
                     </div>
                     <input name = "comment_time" type="hidden" id="dtp_input1" value="{{$project->comment_time}}" /><br/>
                  </div>

                  <fieldset class="form-group">
                     <label for="exampleSelect1">客戶負責人</label>
                     <select class="form-control"  name="user">


                     @if ($project->user_id==1)
                        <option value='1' selected>N/A</option>
                     @else
                        <option value='1'>N/A</option>
                     @endif



                     @if ($project->user_id==2)
                        <option value='2' selected>Reene</option>
                     @else
                        <option value='2'>Reene</option>
                     @endif

                     @if ($project->user_id==4)
                        <option value='4' selected>Chris</option>
                     @else
                        <option value='4'>Chris</option>
                     @endif


                     @if ($project->user_id==5)
                        <option value='5' selected>Chubby</option>
                     @else
                        <option value='5'>Chubby</option>
                     @endif

                     





                     </select>
                  </fieldset>


                   <fieldset class="form-group">
                     <label for="exampleSelect1">客戶類型</label>
                     <select class="form-control"  name="type">
                      @if ($project->type=='DV')
                        <option selected>DV</option>
                     @else
                        <option>DV</option>
                     @endif

                     @if ($project->type=='KEYPO')
                        <option selected>KEYPO</option>
                     @else
                        <option>KEYPO</option>
                     @endif
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >公司名稱</label>
                     <input type="text" name="company" value="{{$project->company}}" class="form-control"  placeholder="請輸入公司名稱">
                  </fieldset>
                 
                  

                   <fieldset class="form-group">
                     <label for="exampleSelect1">專案等級</label>
                     <select class="form-control" id="exampleSelect1" name="level">
                     @if ($project->level=='A')
                        <option selected>A</option>
                     @else
                        <option>A</option>
                     @endif

                     @if ($project->level=='B')
                        <option selected>B</option>
                     @else
                        <option>B</option>
                     @endif

                     @if ($project->level=='C')
                        <option selected>C</option>
                     @else
                        <option>C</option>
                     @endif

                     @if ($project->level=='D')
                        <option selected>D</option>
                     @else
                        <option>D</option>
                     @endif
                     
                     @if ($project->level=='E')
                        <option selected>E</option>
                     @else
                        <option>E</option>
                     @endif

                     @if ($project->level=='F')
                        <option selected>F</option>
                     @else
                        <option>F</option>
                     @endif


                     @if ($project->level=='G')
                        <option selected>G</option>
                     @else
                        <option>G</option>
                     @endif
                       
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >聯絡人</label>
                     <input type="text" name="contacter" value="{{$project->contacter}}" class="form-control"  placeholder="請輸入聯絡人姓名">
                  </fieldset>


                  <fieldset class="form-group">
                     <label  >職稱</label>
                     <input type="text" name="job" value="{{$project->job}}" class="form-control"  placeholder="請輸入聯絡人職稱">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >手機號碼</label>
                     <input type="text" name="phone" value="{{$project->phone}}" class="form-control"  placeholder="請輸入聯絡人手機號碼">
                  </fieldset>



                  <fieldset class="form-group">
                     <label  >公司電話</label>
                     <input type="text" name="telephone" value="{{$project->telephone}}" class="form-control"  placeholder="請輸入公司電話">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >Email</label>
                     <input id="email" type="email" class="form-control" name="email" value="{{$project->email}}" placeholder="請輸入聯絡人 Email">

                  </fieldset>

                    <fieldset class="form-group">
                     <label  >地址</label>
                     <input type="text" name="address" value="{{$project->address}}" class="form-control"  placeholder="請輸入公司地址">
                  </fieldset>
                  

                   <fieldset class="form-group">
                     <label  >拜訪</label>
                     <select class="form-control"   name="visited">
                      @if ($project->visited=='V')
                        <option selected>V</option>
                     @else
                        <option>V</option>
                     @endif

                     @if ($project->visited=='-')
                        <option selected>-</option>
                     @else
                        <option>-</option>
                     @endif

                     @if ($project->visited=='X')
                        <option selected>X</option>
                     @else
                        <option>X</option>
                     @endif
                       
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >合作方法</label>
                     <input type="text" name="coperate_method" value="{{ $project->coperate_method }}" class="form-control"  placeholder="請輸入合作方法">
                  </fieldset>


                  <fieldset class="form-group">
                     <label  >合作內容</label>
                     <input type="text" name="coperate_content" value="{{ $project->coperate_content }}" class="form-control"  placeholder="請輸入合作內容">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >第一次聯繫資訊</label>
                     <input type="text" name="first_contact" value="{{ $project->first_contact }}" class="form-control"  placeholder="請輸入第一次聯繫資訊">
                  </fieldset>


                  <fieldset class="form-group">
                      <label  >第二次聯繫資訊</label>
                     <input type="text" name="second_contact" value="{{ $project->second_contact }}" class="form-control"  placeholder="請輸入第一次聯繫資訊">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >第三次聯繫資訊</label>
                     <input type="text" name="third_contact" value="{{ $project->third_contact }}" class="form-control"  placeholder="請輸入第一次聯繫資訊">
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >成交狀態</label>
                     <select class="form-control"   name="deal">

                     @if ($project->deal=='結案')
                        <option selected>結案</option>
                     @else
                        <option>結案</option>
                     @endif

                     @if ($project->deal=='長期追蹤')
                        <option selected>長期追蹤</option>
                     @else
                        <option>長期追蹤</option>
                     @endif

                     @if ($project->deal=='不聯絡')
                        <option selected>不聯絡</option>
                     @else
                        <option>不聯絡</option>
                     @endif


                      @if ($project->deal=='回傳訂單')
                        <option selected>回傳訂單</option>
                     @else
                        <option>回傳訂單</option>
                     @endif


                     @if ($project->deal=='已付款')
                        <option selected>已付款</option>
                     @else
                        <option>已付款</option>
                     @endif


                     @if ($project->deal=='聯繫中')
                        <option selected>聯繫中</option>
                     @else
                        <option>聯繫中</option>
                     @endif
                       
                     </select>
                  </fieldset>

                  <fieldset class="form-group">
                     <label  >預算(萬)</label>
                     <input type="number" name ="budget" class="form-control"  min="0" step="1" value = '{{$project->budget}}'  />
                  </fieldset>


                  <fieldset class="form-group">
                     <label  >備註</label>
                     <textarea name="remark" rows="10" class="form-control"  placeholder="請輸入專案備註">{{$project->remark}}</textarea>
                  </fieldset>

                  <button class="btn btn-lg btn-info">修改專案</button>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
@section('footer')
<!-- Latest compiled and minified JavaScript -->
<script type="text/javascript" src="/sales/public/dist/js/bootstrap-datetimepicker.js" charset="UTF-8"></script>
<script type="text/javascript" src="/sales/public/dist/js/locales/bootstrap-datetimepicker.fr.js" charset="UTF-8"></script>
<script type="text/javascript">
   $('.form_datetime').datetimepicker({
       //language:  'fr',
       weekStart: 1,
       todayBtn:  1,
   autoclose: 1,
   todayHighlight: 1,
   startView: 2,
   forceParse: 0,
       showMeridian: 1
   });
   $('.form_date').datetimepicker({
       language:  'fr',
       weekStart: 1,
       todayBtn:  1,
   autoclose: 1,
   todayHighlight: 1,
   startView: 2,
   minView: 2,
   forceParse: 0
   });
   $('.form_time').datetimepicker({
       language:  'fr',
       weekStart: 1,
       todayBtn:  1,
   autoclose: 1,
   todayHighlight: 1,
   startView: 1,
   minView: 0,
   maxView: 1,
   forceParse: 0
   });
</script>
@endsection