@extends('layouts.app')

@section('content')

<div class="container">
    <div class="row">

        <div class="col-md-10 col-md-offset-1 " style="padding: 0px;">

            

            <div class="col-md-8 ">
                <div class="panel panel-danger">
                    <div class="panel-heading">大數聚上週數據</div>
               
                    <div class="panel-body">
                         <div id="lastweek"></div>

                    </div>

                </div>
            </div>



            <div class="col-md-4 ">
                <div class="panel panel-danger">
                    <div class="panel-heading">關鍵數據</div>
               
                    <div class="panel-body">

                        <h5 style="border-bottom:1px solid  #01AB91 ; padding-bottom:10px;"> 上週總瀏覽量 </h5>
                       
                        <h4>                        {{$usersandpageviews["rows"][0]["ga:pageviews"]}}</h4>
                        <br>
                        
                        <h5 style="border-bottom:1px solid  #01AB91 ; padding-bottom:10px;"> 使用者 </h5>



                        <h4>                        {{$usersandpageviews["rows"][0]["ga:visits"]}}</h4>

                        <br>
                        

                        <h5 style="border-bottom:1px solid  #01AB91 ; padding-bottom:10px;"> 跳出率 </h5>

                        
                         <h4> {{ round($usersandpageviews["rows"][0]["ga:visitBounceRate"])."%"  }}</h4>

                        <br>
                        

                        <h5 style="border-bottom:1px solid  #01AB91 ; padding-bottom:10px;"> 平均停留時間 </h5>

                        <h4>                        {{ round($usersandpageviews["rows"][0]["ga:avgTimeOnSite"])."s" }}</h4>


                        <br>


                        


                        
                        


                    </div>

                </div>
            </div>




        </div>

        



        <div class="col-md-10 col-md-offset-1">
            <div class="panel panel-danger">
                <div class="panel-heading">上週熱門內容</div>
               
                <div class="panel-body">
<div class="table-responsive"> 
                <table id="example" class="table  table-bordered dt-responsive pre-wrap" cellspacing="0"  >
        <thead>
            <tr>
                <th>pagePath</th>
                <th>pageviews</th>
                <th>uniquePageviews</th>
                <th>timeOnPage(min)</th>
                <th>bounces-rate</th>
                <th>entrances</th>
                <th>exits</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>pagePath</th>
                <th>pageviews</th>
                <th>uniquePageviews</th>
                <th>timeOnPage(min)</th>
                <th>bounces-rate</th>
                <th>entrances</th>
                <th>exits</th>
            </tr>
        </tfoot>
        <tbody>
        @foreach ($topcontent["rows"] as $key) 
            <tr style="width:100%">
                <td class="AutoNewline"><a href="{{ url('http://dailyview.tw'. $key['ga:pagePath']) }}"><p>{{ $key["ga:pagePath"] }}</a></p></td>
                <td>{{ $key["ga:pageviews"] }}</td>
                <td>{{ $key["ga:uniquePageviews"] }}</td>
                <td>{{ intval($key["ga:timeOnPage"])/intval($key["ga:pageviews"])/60}}</td>
                <td>{{ intval($key["ga:bounces"])/ intval($key["ga:pageviews"]) }}</td>
                <td>{{ $key["ga:entrances"] }}</td>
                <td>{{ $key["ga:exits"] }}</td>
            </tr>
        @endforeach
           
            
        </tbody>
    </table>
</div>

                </div>
            </div>
        </div>





    </div>

    <div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">熱門文章</h4>
      </div>
     <div id="modal-load" class="modal-body" style="display:block;text-align: center">
         



      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>




</div>
@endsection


@section("footer")



<script type="text/javascript">
$(function () {
    $("#lastweek").highcharts({
        title: {
            text: "",
            x: -20 //center
        },

        xAxis: {
            type: "category",
            categories: [




            @foreach($lastweek['rows'] as $key)
            {{ $key["ga:date"]."," }}
            @endforeach

]
        },
        yAxis: {
            title: {
                text: "Click"
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: "#808080"
            }]
        },

        legend: {
            layout: "vertical",
            align: "right",
            verticalAlign: "middle",
            borderWidth: 0
        },
        plotOptions: {
            series: {
                cursor: 'pointer',
                point: {
                    events: {
                        click: function () {
                            var date = this.category;
                            var link = "thisday/"+  this.category+" #modal-load";
                            $( "#modal-load" ).html("loading......");
                            $( "#modal-load" ).load(link);
                            $('#myModal').modal('show');

                        }
                    }
                }
            }
        },
        series: [{
            name: "瀏覽量",
            data: [





 @foreach($lastweek['rows'] as $key)
            {{ $key["ga:pageviews"]."," }}
            @endforeach


]
        } ]
    });






});



</script>




@endsection