<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/


Route::auth();

Route::get('/home', 'HomeController@index');


Route::get('/redirect', 'SocialAuthController@redirect');
Route::get('/callback', 'SocialAuthController@callback');


Route::get('/goexcel', 'ProjectController@goexcel');

Route::group(['middleware' => 'auth'], function() {  
    Route::resource('project', 'ProjectController');


    Route::get('/goexcel', 'ProjectController@goexcel_empty');
    Route::get('/goexcel/{type}', 'ProjectController@goexcel');
    Route::get('/projectList/{m}', 'ProjectController@projectlist');
    Route::get('/projectList', 'ProjectController@projectlist_empty');
    Route::get('/projectdv/{m}', 'ProjectController@project_dv');
    Route::get('/projectkeypo/{m}', 'ProjectController@project_keypo');
    Route::get('/project/{id}/delete', 'ProjectController@delete');
    Route::post('/project/search', 'ProjectController@search');
    Route::post('/project/filter', 'ProjectController@filter');


    });






Route::group(['middleware' => 'auth'], function() {  


Route::get('/', 'GoogleController@now');
Route::get('/home', 'HomeController@index');
Route::get('/ga', 'GoogleController@index');
Route::get('/gaf', 'GoogleController@gafunctions');
Route::get('/gatest', 'GoogleController@test');
Route::get('/now', 'GoogleController@now');
Route::get('/month', 'GoogleController@month');
Route::get('/week', 'GoogleController@week');
Route::get('/click', 'GoogleController@comingsoon');
Route::get('/thisday/{time}', 'GoogleController@thisday');
Route::get('/gmail', 'GoogleController@gmail');



});