<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Project;
use App\oldproject;
use App\User;
use Excel;

class ProjectController extends Controller
{
    //
	public function create()
  {
    	return view('project.newProject');
  }
  
  public function store(Request $request)
  {
    //$uid = $request->user()->id;
    $project = new Project;
    $project->comment_time = $request->get('comment_time');
    $project->company = $request->get('company');
    $project->level = $request->get('level');
    $project->type = $request->get('type');
    $project->contacter = $request->get('contacter');
    $project->job = $request->get('job');
    $project->phone = $request->get('phone');
    $project->telephone = $request->get('telephone');
    $project->email = $request->get('email');
    $project->address = $request->get('address');
    $project->visited = $request->get('visited');
    $project->coperate_method = $request->get('coperate_method');
    $project->coperate_content = $request->get('coperate_content');

    $project->first_contact = $request->get('first_contact');
    $project->second_contact = $request->get('second_contact');
    $project->third_contact = $request->get('third_contact');
    $project->deal = $request->get('deal');
    $project->budget = $request->get('budget');
    $project->remark = $request->get('remark');
    $project->user_id = $request->get('user');


   

        




    if ($project->save()) {
        return redirect('/');
    } else {
        return redirect()->back()->withInput()->withErrors('保存失敗！');
    }
  }

   public function projectlist($m)
  {
    if ($m=='time') {
      # code...
      $projects = Project::orderBy('comment_time','desc')->get();
      return(view("project.projects",compact('projects','m')));
    }
    else if ($m=='level') {
      # code...
      $projects = Project::orderBy('level','asc')->get();
      return(view("project.projects",compact('projects','m')));
    }
    else if ($m=='budget') {
      # code...
      $projects = Project::orderBy('budget','desc')->get();
      return(view("project.projects",compact('projects','m')));
    }
    else if($m=='last_modify')
    {
      $projects = Project::orderBy('updated_at','desc')->get();
      return(view("project.projects",compact('projects','m')));

    }
		
    	
  }


  public function project_dv($m)
  {
    if ($m=='time') {
      # code...
      $projects = Project::where('type','DV')->orderBy('comment_time','desc')->get();
      return(view("project.dv",compact('projects','m')));
    }
    else if ($m=='level') {
      # code...
      $projects = Project::where('type','DV')->orderBy('level','asc')->get();
      return(view("project.dv",compact('projects','m')));
    }
    else if ($m=='budget') {
      # code...
      $projects = Project::where('type','DV')->orderBy('budget','desc')->get();
      return(view("project.dv",compact('projects','m')));
    }
    else if($m=='last_modify')
    {
      $projects = Project::where('type','DV')->orderBy('updated_at','desc')->get();
      return(view("project.dv",compact('projects','m')));

    }
    
      
  }

  public function goexcel($type)
  {


       $projects = Project::orderBy('comment_time','desc')->get();

    if ($type=='All') {
      # code...
      $projects = Project::orderBy('comment_time','desc')->get();
    }
    else if ($type=='DV') {
      # code...
      $projects = Project::where('type','DV')->orderBy('comment_time','desc')->get();
    }
    else if ($type=='KEYPO') {
      # code...
      $projects = Project::where('type','KEYPO')->orderBy('comment_time','desc')->get();
    }
    else
    {
      $projects = Project::orderBy('comment_time','desc')->get();
    }

    Excel::create('DV 業務', function($excel) use ($projects) {

      $excel->sheet('New sheet', function($sheet)  use ($projects)  {

        $sheet->loadView('project.excel')->with('projects',$projects);

      });

    })->export('xlsx');






  }

  public function goexcel_empty()
  {
    return redirect('goexcel/All');


      




  }

  

    public function project_keypo($m)
  {
    if ($m=='time') {
      # code...
      $projects = Project::where('type','KEYPO')->orderBy('comment_time','desc')->get();
      return(view("project.keypo",compact('projects','m')));
    }
    else if ($m=='level') {
      # code...
      $projects = Project::where('type','KEYPO')->orderBy('level','asc')->get();
      return(view("project.keypo",compact('projects','m')));
    }
    else if ($m=='budget') {
      # code...
      $projects = Project::where('type','KEYPO')->orderBy('budget','desc')->get();
      return(view("project.keypo",compact('projects','m')));
    }
    else if($m=='last_modify')
    {
      $projects = Project::where('type','KEYPO')->orderBy('updated_at','desc')->get();
      return(view("project.keypo",compact('projects','m')));

    }
    
      
  }


   public function projectlist_empty()
  {

      return redirect('projectList/last_modify');
      
  }

     public function oldtonew(Request $request)
  {

  	 $uid = $request->user()->id;
  	$oldprojects = oldproject::all();
  	foreach ($oldprojects as $oldproject) {
  		# code...
  		$project = new Project;
  		$project->comment_time = $oldproject->comment_time ;
  		$project->company = $oldproject->company ;
  		$project->level = $oldproject->level ;
  		$project->contacter = $oldproject->contacter ;
  		$project->job = $oldproject->job ;
  		$project->phone = $oldproject->phone ;
  		$project->email = $oldproject->email ;
  		$project->address = $oldproject->address ;
  		$project->visited = $oldproject->visited ;
  		$project->coperate_method = $oldproject->coperate_method ;
  		$project->coperate_content = $oldproject->coperate_content ;
  		$project->first_contact = $oldproject->first_contact ;
    	$project->second_contact = $oldproject->second_contact ;
    	$project->third_contact = $oldproject->third_contact ;
    	$project->deal = $oldproject->deal ;
    	$project->budget = 10;
    	$project->remark = '預算'.$oldproject->budget ;
    	$project->user_id =$uid;
    	$project->save();






  	}


    if ($project->save()) {
        return redirect('/');
    } else {
        return redirect()->back()->withInput()->withErrors('保存失敗！');
    }
    	
  }

  public function show (Project $project){
        $uid = $project->user_id;
        $user = User::find($uid);
			return(view("project.show",compact('project','user')));
	}

		public function edit(Project $project)
	{
		
		return( view("project.edit",compact("project")) );
	}


  public function update(Request $request,Project $project)
  {


    $project->comment_time = $request->get('comment_time');
    $project->type = $request->get('type');
    $project->company = $request->get('company');
    $project->level = $request->get('level');
    $project->contacter = $request->get('contacter');
    $project->job = $request->get('job');
    $project->phone = $request->get('phone');
    $project->telephone = $request->get('telephone');
    $project->email = $request->get('email');
    $project->address = $request->get('address');
    $project->visited = $request->get('visited');
    $project->coperate_method = $request->get('coperate_method');
    $project->coperate_content = $request->get('coperate_content');

    $project->first_contact = $request->get('first_contact');
    $project->second_contact = $request->get('second_contact');
    $project->third_contact = $request->get('third_contact');
    $project->deal = $request->get('deal');
    $project->budget = $request->get('budget');
    $project->remark = $request->get('remark');
    $project->user_id = $request->get('user');

    
    $project->save();

    return( back() );
  }

  public function delete(Request $request,$id)  
  {
      $project = Project::find($id);

        return view('project.delete',compact('project'));
      
  }

  public function destroy($id)  
  {
      Project::find($id)->delete();
      return redirect('/projectList')->withInput()->withErrors('删除成功！');

  }

    public function search(Request $request)  
  {
      $search  = $request->get('srch-term');

      $projects = Project::where('company','LIKE',"%$search%")
                    ->orWhere('contacter','LIKE',"%$search%")
                    ->orWhere('remark','LIKE',"%$search%")
                    ->orderBy('comment_time','desc')->get();

        return view('project.search',compact('projects'));
      
  }


      public function filter(Request $request)  
  {
      $user  = $request->get('user');

      $type  = $request->get('type');
      $level  = $request->get('level');
      $deal  = $request->get('deal');
      $odby  = $request->get('odby');



      $daterange  = strip_tags($request->get('daterange-hidden'));
      


      $daterange =  preg_replace("/\s|&nbsp;/",'',$daterange);

      //echo $daterange;


      $daterange_2 = explode('-', $daterange);
      $startdate =   $daterange_2[0];
      $enddate =   $daterange_2[1];


      //echo substr($startdate,-4);
      $dot = strpos($startdate,',');
      //echo substr($startdate,$dot-2,2);
      //echo trim(html_entity_decode(substr($startdate,0,$dot-2)));
      $startdate = trim(html_entity_decode(substr($startdate,0,$dot-2)))." ".substr($startdate,$dot-2,2)." ".substr($startdate,-4);
      //echo "<br>".$startdate."<br>";

      //echo substr($enddate,-4);
      $dot = strpos($enddate,',');
      //echo substr($enddate,$dot-2,2);
      //echo trim(html_entity_decode(substr($enddate,0,$dot-2)));
      $enddate = trim(html_entity_decode(substr($enddate,0,$dot-2)))." ".substr($enddate,$dot-2,2)." ".substr($enddate,-4);
      //echo "<br>".$enddate."<br>";

       $startdate = date('Y-m-d', strtotime($startdate)) ;
       $enddate = date('Y-m-d', strtotime($enddate)) ;


       $projects = Project::where('comment_time','>',$startdate)->Where('comment_time','<',$enddate);
       if ($user!=1) {
         # code...
         $projects  = $projects ->where('user_id',$user);
       }
       if ($type!='N/A') {
         # code...
         $projects  = $projects ->where('type',$type);
       }
       if ($level!='N/A') {
         # code...
         $projects  = $projects ->where('level',"=",$level);
       }
       if ($deal!='N/A') {
         # code...
         $projects  = $projects ->where('deal',">",$level);
       }

       if ($odby=='留言時間') {
         # code...
         $projects  = $projects ->orderBy('comment_time','desc');
       }
       else if ($odby=='修改時間') {
         # code...
        $projects  = $projects ->orderBy('updated_at','desc');
       }
       else if ($odby=='預算') {
         # code...
        $projects  = $projects ->orderBy('budget','desc');
       }

       $projects = $projects->get();

       $userf = User::find($user);
       $username=  $userf->name;
       if ($username == 'jason') {
         # code...
         $username = 'N/A';
       }


       $filterString = "目前排序 : 使用者 ".$username." 客戶類型 : ".$type." 客戶等級 : ".$level." 成交狀態 : ".$deal." 排序依照 : ".$odby;

       return view('project.filter',compact('projects','filterString'));
                    

      
   }



  /*
 

  public function index()
  {
  	     $projects = Project::where('status','公開')->get();
		return(view("project.projects",compact('projects')));
    	
  }

  

	public function my (Request $request){
		$uid = $request->user()->id;
		$projects1 = Project::where('user_id', $uid)->where('status','公開')->get();
        $projects2 = Project::where('user_id', $uid)->where('status','等待審核')->get();
        $projects3 = Project::where('user_id', $uid)->where('status','否決')->get();
		return(view("project.my",compact('projects1','projects2','projects3')));
	}

	
	

	
	*/
}
